#include "multiplot.h"

// These are  compiler directives that includes libraries (For Visual Studio)
// You can manually include the libraries in the "Project->settings" menu under
// the "Link" tab.  You need these libraries to compile this program.
// this project file is configured in "multithreaded dll" mode. if your fltk was build using 
// "multithreaded" mode, you must change the code generation compiler settings.
#ifdef _WIN32
	#pragma comment(lib, "opengl32.lib")
	#pragma comment(lib, "wsock32.lib")
	#pragma comment(lib, "comctl32.lib")
	#pragma comment(lib, "fltk.lib")
	#pragma comment(lib, "fltkgl.lib")
#endif

int main()
{
	// create three multiplot windows
	MULTIPLOT m1(10,10,300,300);
	MULTIPLOT m2(10,350,500,200);
	MULTIPLOT m3(10,580,500,100);
	m1.show();
	m2.show();
	m3.show();

	// for window 1 and 2 enable scrolling. 
	m1.set_scrolling(200);		// the last 200 added points of the plot will be drawn 
	m2.set_scrolling(50);		// the last  50 added points of the plot will be drawn 
	m1.set_linewidth(0, 1.5);	// first trace has line-width of 2	
	m1.set_pointsize(0, 4);		// set the point size of the first trace to 4


	// enable the drawing of gridlines.
	m1.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis
	m2.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis
	m3.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis


	int x=0;
	int time=clock();
	
	while(Fl::check()) // process events.
	{
		if(clock() - time > 20)
		{
			time=clock();
			// add points to the plot-windows. the first value is the number of the trace,
			// the second is the plot-point to be added.
			m1.add(0,PLOT_POINT(0.1*x*cos(x/5.0), 0.1*x*sin(x/5.0)));
			m1.add(10,PLOT_POINT(0.1*x*cos(x/20.0), 0.1*x*sin(x/5.0),0,1,0));
			m2.add(0,PLOT_POINT(x, 0.1*x*sin(x/5.0),1,0,1));
			m2.add(1,PLOT_POINT(x, 0.1*x*sin(x/6.0),1,1,0));
			//m3.add(0,PLOT_POINT(x, -200+0.1*x*sin(x/6.0),1,1,0));
			m3.add(0,PLOT_POINT(x, 0.1*x*sin(x/6.0),1,1,0));
			
			if((x % 200)==0)m3.clear();	// clear the traces of plot-window 3
			
			x++;
			// force the redrawing of the windows. 
			// this could be done less often, for example every tenth timestep,  to speed up calculations.
			m1.redraw();
			m2.redraw();
			m3.redraw();
		}
		Fl::wait(0); // release cpu cycles
	}
	return 0;
}