#include "multiplot.h"

// This is a compiler directive that includes libraries (For Visual Studio)
// You can manually include the libraries in the "Project->settings" menu under
// the "Link" tab.  You need these libraries to compile this program.
#pragma comment(lib, "opengl32.lib")
#ifdef _WIN32
#pragma comment(lib, "wsock32.lib")
#endif
#ifdef _DEBUG
	#pragma comment(lib, "fltkd.lib")
	#pragma comment(lib, "fltkgld.lib")
#else
	#pragma comment(lib, "fltk.lib")
	#pragma comment(lib, "fltkgl.lib")
#endif


void main()
{
	// create three multiplot windows
	MULTIPLOT m1(10,10,300,300);
	MULTIPLOT m2(10,350,500,200);
	MULTIPLOT m3(10,580,500,100);
	// for window 1 and 2 enable scrolling. 
	m1.set_scrolling(200);	// the last 200 added points of the plot will be drawn 
	m2.set_scrolling(50);	// the last  50 added points of the plot will be drawn 


	// enable the drawing of gridlines.
	m1.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis
	//m2.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID, 0.1, 0.1);	// draw a linear spaced grid for x and y-axis with grid-spacing of 0.1
	m2.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis
	m3.set_grid(MP_LINEAR_GRID,MP_LINEAR_GRID);		// draw a linear spaced grid for x and y-axis

	int x=0;
	int time=clock();
	while(1)
	{
		if(clock() - time > 20)
		{
			time=clock();
			// add points to the plot-windows. the first value is the number of the trace,
			// the second is the plot-point to be added.
			m1.add(0,PLOT_POINT(0.1*x*cos(x/5.0), 0.1*x*sin(x/5.0)));
			m1.add(10,PLOT_POINT(0.1*x*cos(x/20.0), 0.1*x*sin(x/5.0),0,1,0));
			m2.add(0,PLOT_POINT(x, 0.1*x*sin(x/5.0),1,0,1));
			m2.add(1,PLOT_POINT(x, 0.1*x*sin(x/6.0),1,1,0));
			m3.add(0,PLOT_POINT(x, -200+0.1*x*sin(x/6.0),1,1,0));
			
			x++;
			// force the redrawing of the windows. 
			// this could be done less often, for example every tenth timestep,  to speed up calculations.
			m1.redraw();
			m2.redraw();
			m3.redraw();
		}
		// process events.
		Fl::check();	
	}
}